/* eslint-disable camelcase */
/**
 * WordPress dependencies
 */

const { __ } = wp.i18n;
const {
	BaseControl,
	Button,
	ExternalLink,
	PanelBody,
	PanelRow,
	Placeholder,
	Spinner,
	ToggleControl,
	Notice,
	Snackbar,
	SnackbarList,
	Card,
  	CardHeader,
	CardBody,
	CardFooter,
	SelectControl
	
} = wp.components;

const {
	render,
	Component,
	Fragment,
	useState,
} = wp.element;

const {
	useDispatch,
	dispatch, 
	withSelect, 
	withDispatch
} = wp.data;

const {
	compose,
} = wp.compose;

const {store: noticesStore} = wp.notices;

const Notices = ({ notices, removeNotice }) => {
    const snackbarNotices = notices ? notices.filter((notice) => notice.type === 'snackbar') : [];
    return (
        <>
            <SnackbarList
                className="every-alt-notices"
                notices={snackbarNotices}
                onRemove={removeNotice}
            />
        </>
    );
}

const AppNotices = compose(
    withSelect((select) => ({
        notices: select('core/notices').getNotices(),
    })),
    withDispatch((dispatch) => ({
        removeNotice: dispatch('core/notices').removeNotice,
    })),
)(Notices);



class App extends Component {
	constructor(props) {
		super( ...arguments );
		
		this.changeOptions = this.changeOptions.bind( this );
		this.state = {
			isAPILoaded: false,
			isAPISaving: false,
			every_alt_auto: false,
			every_alt_fulltext: false,
			every_alt_secret: '',
			every_alt_language: '',
			every_alt_httpuser: '',
			every_alt_httpassword: '',
			every_alt_tokens: '',
			every_alt_used_tokens: '',
			every_alt_progress: '',
			every_alt_error: '',
			snackbar_message:'',
		};
	}
	

	

	componentDidMount() {
		wp.api.loadPromise.then( () => {
			this.settings = new wp.api.models.Settings();
			if ( false === this.state.isAPILoaded ) {
				this.settings.fetch().then( response => {
					this.setState({
						every_alt_secret: response.every_alt_secret,
						every_alt_auto: response.every_alt_auto,
						every_alt_fulltext: response.every_alt_fulltext,
						every_alt_language: response.every_alt_language,
						every_alt_httpuser: response.every_alt_httpuser,
						every_alt_httpassword: response.every_alt_httpassword,
					});

					wp.apiRequest( { path: 'every-alt-api/v1/get_tokens' } )
					.then( response => {
						this.setState({
							every_alt_tokens: response.tokens,
							every_alt_used_tokens: response.used_tokens,
							every_alt_error: response.error,
							isAPILoaded: true
						});
					});
				});

				
			}

			
		});
	}

	changeOptionsHttp( options, values ) {
		this.setState({ isAPISaving: true });

		const model = new wp.api.models.Settings({
			[options[0]]: values[0],
			[options[1]]: values[1]
		});


		model.save().then( response => {
			options.forEach((option, i) => {
				this.setState({
					[option]: response[option]
				});
				if (i === options.length - 1) {
					this.setState({ isAPISaving: false });
					dispatch('core/notices')
					.createNotice(
						'success',
						__('Settings Saved', 'every-alt'),
						{
						type: 'snackbar',
						isDismissible: true,
						spokenMessage: __('Every Alt', 'every-alt'),
						}
					);
				}
			});
		});
	}

	changeOptions( option, value ) {
		this.setState({ isAPISaving: true });

		const model = new wp.api.models.Settings({
			// eslint-disable-next-line camelcase
			[option]: value
		});


		model.save().then( response => {
			this.setState({
				[option]: response[option],
				isAPISaving: false
			});
			wp.apiRequest( { path: 'every-alt-api/v1/get_tokens' } )
				.then( response => {
					this.setState({
						every_alt_tokens: response.tokens,
						every_alt_used_tokens: response.used_tokens,
						every_alt_error: response.error,
						every_alt_auto: response.auto == 0 ? false:true,
						isAPISaving: false,
					});
					dispatch('core/notices')
					.createNotice(
						'success',
						__('Settings Saved', 'every-alt'),
						{
						type: 'snackbar',
						isDismissible: true,
						spokenMessage: __('Every Alt', 'every-alt'),
						}
					);
			});
		});
	}



	calculateProgress(){
		let progress = (this.state.every_alt_used_tokens*100) / this.state.every_alt_tokens;
		return parseFloat(progress).toFixed(2);
	}
	
	

	

	render() {
		if ( ! this.state.isAPILoaded ) {
			return (
				<Placeholder>
					<Spinner/>
				</Placeholder>
			);
		}

		return (
			
			<Fragment>
				<AppNotices/>
				<div className="every-alt-main">
					<Card>
						<CardBody>
							<div className="every-alt-info">
								<h2>{ __( 'Welcome to EveryAlt!','every-alt' ) }</h2>
								<p>{ __( 'Every image deserves accurate, descriptive alternative text. EveryAlt harnesses the power of multiple artificial intelligence models to recognize every image you upload and instantly create simple, clear descriptive text. That means it\'s easier than ever to make sure your site is accessible, search-engine optimized, and easily understandable for visitors who use screen readers and other assistive technology to browse the web.','every-alt' ) }</p>
								<p>{ __( 'If you haven\'t yet, create your EveryAlt account and generate some alternative text with the free credits you receive when you sign up. If EveryAlt knocks your socks off, you can purchase thousands of image credits for just a few bucks, and you can share those credits across unlimited WordPress sites.','every-alt' ) }</p>
								<div className="every-alt-info-button-group">
									<Button
										isSecondary
										target="_blank"
										href="https://everyalt.com/"
									>
										{ __( 'Log In or Create Your Free EveryAlt Account','every-alt' ) }
									</Button>
								</div>
							</div>
						</CardBody>
					</Card>
					<Card>
						<CardHeader>
							{ __( 'Settings','every-alt' ) }
						</CardHeader>
						<CardBody>
							<BaseControl
								label={ __( 'My API Key','every-alt' ) }
								help={ __('In order to use EveryAlt, you need an API key. When you create your free EveryAlt account, you\'ll receive a key that includes free image credits to get you started.','every-alt') }
								id="'every-alt-options-api-key"
								className="every-alt-text-field"
							>
								<input
									type="text"
									id="every-alt-options-api-key"
									value={ this.state.every_alt_secret }
									placeholder={ __( 'My API Key','every-alt' ) }
									disabled={ this.state.isAPISaving }
									onChange={ e => this.setState({ every_alt_secret: e.target.value }) }
								/>


								<div className="every-alt-text-field-button-group">
									<Button
										isPrimary
										disabled={ this.state.isAPISaving }
										onClick={ () => this.changeOptions( 'every_alt_secret', this.state.every_alt_secret ) }
									>
										{ __( 'Save Key','every-alt' ) }
									</Button>
									<ExternalLink href="https://everyalt.com">
										{ __( 'Get a Free API Key','every-alt' ) }
									</ExternalLink>
								</div>
								
							</BaseControl>


							{/* http password */}

							{this.state.every_alt_secret && !this.state.every_alt_error
								?
								<div>
									<div className="every_alt_languages_holder">
										<h2>{__('Language','every-alt')}</h2>
										<p>{ __( 'EveryAlt can create alternative text in many languages. Choose your preferred language for alternative text below.','every-alt' ) }</p>
										<SelectControl
										label={ __( 'Select a language','every-alt' ) }
										value={ this.state.every_alt_language }
										options={ [
											{ label: 'English', value: 'English' },
											{ label: 'Spanish', value: 'Spanish' },
											{ label: 'Italian', value: 'Italian' },
											{ label: 'German', value: 'German' },
											{ label: 'Dutch', value: 'Dutch' },
											{ label: 'Norwegian', value: 'Norwegian' },
											{ label: 'Japanese', value: 'Japanese' },
											{ label: 'French', value: 'French' },
											{ label: 'Portuguese', value: 'Portuguese' },
										] }

										onChange={(value) => {
											this.setState({ every_alt_language: value })
											setTimeout(() => {
												this.changeOptions('every_alt_language', this.state.every_alt_language)
											}, 100);
											
										}}

										__nextHasNoMarginBottom
										/>
									</div>

									<div className="every_alt_http_password_holder">
									<h2>{__('Basic Authentication','every-alt')}</h2>
									<p>{__("EveryAlt needs to be able to access your images via the public internet. If your site is protected by basic authentication, enter the username and password below. This is common for staging and development sites.",'every-alt')}</p>
									<BaseControl
										label={ __( 'Username','every-alt' ) }
										id="every-alt-options-http-username"
										className="every-alt-text-field"
									>
										<input
											type="text"
											id="every-alt-options-http-username"
											value={ this.state.every_alt_httpuser }
											placeholder={ __( 'HTTP Basic Auth Username','every-alt' ) }
											disabled={ this.state.isAPISaving }
											onChange={ e => this.setState({ every_alt_httpuser: e.target.value }) }
										/>
									</BaseControl>
									<BaseControl
										label={ __( 'Password','every-alt' ) }
										id="every-alt-options-http-password"
										className="every-alt-text-field"
									>
										<input
											type="password"
											id="every-alt-options-http-password"
											value={ this.state.every_alt_httpassword }
											placeholder={ __( 'HTTP Basic Auth Password','every-alt' ) }
											disabled={ this.state.isAPISaving }
											onChange={ e => this.setState({ every_alt_httpassword: e.target.value }) }
										/>
									</BaseControl>

									<div className="every-alt-text-field-button-group">
										<Button
											isPrimary
											disabled={ this.state.isAPISaving }
											onClick={ () => this.changeOptionsHttp( ['every_alt_httpuser','every_alt_httpassword'], [this.state.every_alt_httpuser,this.state.every_alt_httpassword] ) }
										>
											{ __( 'Save Credentials','every-alt' ) }
										</Button>
									</div>

								</div>
							</div>

							
									
								: null
							}

							

							




							{/* every_alt_httpuser: response.every_alt_httpuser,
						every_alt_httpassword: response.every_alt_httpassword, */}

							{this.state.every_alt_error ? 
								<Notice 
								status="error"
								isDismissible={false}
								>
								{this.state.every_alt_error}
								</Notice> 
							: null }
							{this.state.every_alt_secret && !this.state.every_alt_error
								? 	
									<ToggleControl
										label={ __( 'Automatically Add Alt Text to New Images?','every-alt' ) }
										help={ __('EveryAlt will automatically create alt text for every image you upload to your WordPress Site. You can always manually change the alt text later.','every-alt') }
										checked={ this.state.every_alt_auto }
										onChange={ () => this.changeOptions( 'every_alt_auto', ! this.state.every_alt_auto ) }
									/>
								: null
							}
							{this.state.every_alt_secret && !this.state.every_alt_error
								? 	
									<ToggleControl
										label={ __( 'Append Full Text?','every-alt' ) }
										help={ __('If we detect text in your image, we will append the full text of the image as part of your alternative text. This is great if you upload a lot of screenshots or images of text that you would normally transcribe manually. You can always modify your alt text after it\'s generated.','every-alt') }
										checked={ this.state.every_alt_fulltext }
										onChange={ () => this.changeOptions( 'every_alt_fulltext', ! this.state.every_alt_fulltext ) }
									/>
								: null
							}
							{this.state.every_alt_tokens && this.state.every_alt_secret
								? 	
									<div className="every-alt-progress-bar">
										<div className="every-bar-wrapper">
											<div className="every-bar-bar" style={{width: this.calculateProgress()+"%"}}></div>
										</div>
										<p><strong>{this.calculateProgress()}%</strong> - { __( 'You have used','every-alt' ) } {this.state.every_alt_used_tokens} { __( 'of your','every-alt' ) } {this.state.every_alt_tokens} { __( 'image credits','every-alt' ) } <ExternalLink href="https://everyalt.com">{ __( 'Get More Image Credits','every-alt' ) }</ExternalLink></p>
									</div>
								: null
							}
						</CardBody>
					</Card>

					<Card>
						<CardBody>
							<div className="every-alt-info">
								<h2>{ __( 'Questions or Issues?','every-alt' ) }</h2>
								<p>{ __( 'We\'re for you! While our image-recognition technology is the best in the business, it\'s still not perfect. We\'d love to hear your feedback so we can continuously improve and help everyone build accessible, screen-reader-friendly WordPress sites.', 'every-alt' ) }</p>
								<div className="every-alt-info-button-group">
									<Button
										isSecondary
										target="_blank"
										href="https://everyalt.com/"
									>
										{ __( 'Ask a question','every-alt' ) }
									</Button>
								</div>
								<p style={{marginTop: "1rem"}}>{ __( "EveryAlt is a product of ", 'every-alt' ) } <ExternalLink href="https://everyalt.com">{ __( 'HDC','every-alt' ) }</ExternalLink> { __( "the digital agency behind MasterWP and Understrap. We build high-end WordPress sites for enterprise and small-business clients, and we build software to lead the industry to a better future.", 'every-alt' ) }</p>
							</div>
						</CardBody>
					</Card>

				</div>
			</Fragment>
		);
	}
}


const app = document.getElementById('every-alt-plugin');
ReactDOM.render(<App {...app.dataset} />, app);
