/* eslint-disable camelcase */
/**
 * WordPress dependencies
 */

const { __ } = wp.i18n;
const {
	BaseControl,
	Button,
	ExternalLink,
	PanelBody,
	PanelRow,
	Placeholder,
	Spinner,
	ToggleControl,
	Notice,
	Snackbar,
	Card,
  	CardHeader,
	CardBody,
	CardFooter,
} = wp.components;

const {
	render,
	Component,
	Fragment
} = wp.element;


class App extends Component {
	constructor(props) {
		super( ...arguments );
		this.state = {
			isAPILoaded: false,
			isAPISaving: false,
		};
	}



	componentDidMount() {
		this.setState({
			isAPILoaded: true,
			images: JSON.parse(this.props.images),
			tokens: this.props.tokens,
			used_tokens: this.props.used_tokens,
			generated: [],
			is_generating: false,
			counter:0,
			process_completed:false,
		});
	}



	calculateProgress(){
		let progress = (this.state.used_tokens*100) / this.state.tokens;
		return parseFloat(progress).toFixed(2);
	}

	calculateProgressBulk(){
		let progress = (this.state.counter*100) / this.state.images.length;
		console.log(progress)
		return parseFloat(progress).toFixed(2);
	}


	async generateBulkAlt() {

		this.setState({
			is_generating: true
		});

		for (let index = 0; index < this.state.images.length; index++) {
			const response = await wp.apiRequest({
				path: 'every-alt-api/v1/bulk_generate_alt',
				method: 'POST',
				data: {
				media_id: this.state.images[index],
				},
			});
			if(response.alt_text){
				let array = {
					media : response.media_id,
					alt : response.alt_text,
				}
				this.setState(prevState => ({
					generated: [...prevState.generated, array],
					tokens: response.tokens,
					used_tokens: response.used_tokens,
				}));
				let counter = this.state.counter + 1;
				this.setState({
					tokens: response.tokens,
					used_tokens: response.used_tokens,
					counter : counter,
				});
			}else{
				let array = {
					media : response.media_id,
					alt : __( 'There was a problem with this image. Skipped','every-alt' ),
					error : true,
				}
				this.setState(prevState => ({
					generated: [...prevState.generated, array],
				}));
				let counter = this.state.counter + 1;
				this.setState({
					counter : counter,
				});
			}
			
		}

		this.setState({
			is_generating: false,
			process_completed: true
		});
	  }


	

	render() {
		if ( ! this.state.isAPILoaded ) {
			return (
				<Placeholder>
					<Spinner/>
				</Placeholder>
			);
		}

		if ( ! this.state.tokens ) {
			return (
				<div className="every-alt-main" id="every-alt-main-error">
					<h2>{ __('In order to use EveryAlt, you need an API key.','every-alt') }</h2>
				</div>
			);
		}

		return (
			<Fragment>
				<div className="every-alt-main" id="every-alt-bulk-generator">
					<Card>
						<CardBody>
							{!this.props.error && this.state.tokens
								? 	
									<div className="every-alt-progress-bar">
										<div className="every-bar-wrapper">
											<div className="every-bar-bar" style={{width: this.calculateProgress()+"%"}}></div>
										</div>
										<p><strong>{this.calculateProgress()}%</strong> - { __( 'You have used','every-alt' ) } {this.state.used_tokens} { __( 'of your','every-alt' ) } {this.state.tokens}-{ __( 'image quota','every-alt' ) } <ExternalLink href="https://everyalt.com">{ __( 'Get More','every-alt' ) }</ExternalLink></p>
									</div>
								: null
							}

							{this.state.is_generating
								? 
								<div className="every-alt-spinner-container">
									<div className="every-alt-spinner">
										<Spinner/>
									</div>
									<p>{ __( "Generating your alt text. Don't close this window...",'every-alt' ) }</p>
									<div className="every-alt-progress-bar">
										<div className="every-bar-wrapper">
											<div className="every-bar-bar" style={{width: this.calculateProgressBulk()+"%"}}></div>
										</div>
									</div>
								</div>	
								: null
							}

							{this.state.process_completed
								? 	
								<div className="completed-message">
									<h2>{ __( "Process Completed!",'every-alt' ) }</h2>
								</div>

								: null
							}

							{this.state.images.length > 0 && !this.state.is_generating && !this.state.process_completed
								? 	
								<Button
									isPrimary
									disabled={ this.state.isAPISaving }
									onClick={ () => this.generateBulkAlt() }
									>
										{ __( 'Generate Alt Text for ','every-alt' ) } { this.state.images.length } { __( 'Images','every-alt' ) }
								</Button>
								: null
							}

							{this.state.images.length == 0
								? 	
									<div>
										<h3 style={{marginBottom: "0.25rem"}}>{ __( 'Great work!','every-alt' ) }</h3>
										<p style={{marginTop: "0.25rem"}}>{ __( 'All your images have alternative text. To review alt text that has been generated by EveryAlt, check out your ','every-alt' ) } <a href={this.props.admin + 'upload.php?page=every-alt&tab=history' }>{ __( 'History','every-alt' ) }</a> { __( 'page.','every-alt' ) }</p>
									</div>
								: null
							}




							{this.state.generated.length ? 
								<table>
									<thead>
										<tr>
											<th>{ __( 'Media ID','every-alt' ) }</th>
											<th>{ __( 'Alt Text Generated','every-alt' ) }</th>
										</tr>
									</thead>
									<tbody>
										{this.state.generated.map((item, index) => (
										<tr className={index % 2 == 0 ? 'even':'odd'} key={index}>
											<td>
												<ExternalLink href={this.props.admin + 'post.php?post=' + item.media + '&action=edit' }>
													{item.media}
												</ExternalLink>
											</td>
											<td className={item.error ? 'has_error':''}>{item.alt}</td>
										</tr>
										))}
									</tbody>
								</table>
							: null }
						</CardBody>

						
					</Card>

					
				</div>
			</Fragment>
		);
	}
}


const app = document.getElementById('every-alt-bulk');
ReactDOM.render(<App {...app.dataset} />, app);
