const { __ } = wp.i18n;

const {
	Fragment,
    Component,
} = wp.element;

const {
	PanelBody,
} = wp.components;

const {
	InspectorControls,
} = wp.blockEditor;

const {
	createHigherOrderComponent,
} = wp.compose;

const {
	registerPlugin,
} = wp.plugins;

const {
	Button,
    useEffect,
    Spinner
} = wp.components;

const {
	dispatch
} = wp.data;





class EveryAltGutenbergButton extends Component {
    constructor(props) {
		super( ...arguments );
		this.state = {
			isAPILoaded: false,
			every_alt_tokens: '',
			every_alt_used_tokens: '',
            userHasTokens:false,
		};
	}
    componentDidMount() {
    wp.apiRequest( { path: 'every-alt-api/v1/get_tokens' } )
		.then( response => {
            this.setState({
                every_alt_tokens: response.tokens,
                every_alt_used_tokens: response.used_tokens,
                isAPILoaded: true
            });
	    });
    }
  
    handleClick = () => {
        const { id } = this.props;
        this.setState({
            isAPILoaded: false
        });
        wp.apiRequest({
			path: 'every-alt-api/v1/bulk_generate_alt',
			method: 'POST',
			data: {
			media_id: id,
			},
		}).then( response => {
            this.setState({
                isAPILoaded: true
            });
            if(response.alt_text){
                this.setState({
                    every_alt_tokens: response.tokens,
                    every_alt_used_tokens: response.used_tokens,
                });
                this.props.setAttributes({ alt: response.alt_text });
                this.showSnackbarNotice(__( 'Alt Text Succesfully Generated','every-alt' ));
            }else{
                this.showSnackbarNotice(__( 'Something is not quite right, please try again later','every-alt' ));
            }
		});
    };


    showSnackbarNotice = (message) => {
        dispatch('core/notices')
			.createNotice(
			'success',
                message,
				{
				type: 'snackbar',
				isDismissible: true,
				spokenMessage: __('Every Alt', 'every-alt'),
				}
		);
    };

   
    render() {

        if ( ! this.state.isAPILoaded ) {
			return (
				<Spinner/>
			);
	    }


      if ( this.state.every_alt_tokens - this.state.every_alt_used_tokens <= 0 ) {
			  return (
          <div>No Token</div>
        );
	    }

        return (

            <div>
            <Button isPrimary onClick={this.handleClick}>
               {__('Generate Alt Text', 'every-alt')}
            </Button>
            <p>{__('Available Image Quota', 'every-alt')}: <strong>{this.state.every_alt_tokens - this.state.every_alt_used_tokens}</strong></p>
            </div>

          
        );
    }
  };




const addCustomButtonToImageBlock = createHigherOrderComponent( ( BlockEdit ) => {
  return ( props ) => {
    const { attributes, setAttributes, name } = props;
    const mediaId = attributes.id;
    const altText = attributes.alt;

    if (name !== "core/image" || !mediaId) {
        return <BlockEdit {...props} />;
    }

    return (
    <Fragment>
        <BlockEdit { ...props } />
        <InspectorControls>
          <PanelBody title={ __( 'EveryAlt','every-alt' ) } initialOpen={ true }>
            <div id="every-alt-gutenber-button">
              <EveryAltGutenbergButton altText={altText} id={mediaId} setAttributes={setAttributes} />
            </div>
          </PanelBody>
        </InspectorControls>
      </Fragment>
    );
  };
}, 'addCustomButtonToImageBlock' );

wp.hooks.addFilter(
  'editor.BlockEdit',
  'my-plugin/add-custom-button-to-image-block',
  addCustomButtonToImageBlock
);

registerPlugin( 'every-alt-plugin', {
  render: () => null,
} );
