/* eslint-disable camelcase */
/**
 * WordPress dependencies
 */

const { __ } = wp.i18n;
const {
	BaseControl,
	Button,
	ExternalLink,
	PanelBody,
	PanelRow,
	Placeholder,
	Spinner,
	ToggleControl,
	Notice,
	Snackbar,
	SnackbarList,
	Card,
  	CardHeader,
	CardBody,
	CardFooter,
	TextareaControl
	
} = wp.components;

const {
	render,
	Component,
	Fragment,
} = wp.element;

const {
	useDispatch,
	dispatch, 
	withSelect, 
	withDispatch
} = wp.data;

const {
	compose,
} = wp.compose;



const {store: noticesStore} = wp.notices;

const Notices = ({ notices, removeNotice }) => {
    const snackbarNotices = notices ? notices.filter((notice) => notice.type === 'snackbar') : [];
    return (
        <>
            <SnackbarList
                className="every-alt-notices"
                notices={snackbarNotices}
                onRemove={removeNotice}
            />
        </>
    );
}

const AppNotices = compose(
    withSelect((select) => ({
        notices: select('core/notices').getNotices(),
    })),
    withDispatch((dispatch) => ({
        removeNotice: dispatch('core/notices').removeNotice,
    })),
)(Notices);


class App extends Component {
	constructor(props) {
		super( ...arguments );
		this.state = {
			isAPILoaded: false,
			isAPISaving: false,
			images: Array,
			old_images: Array,
		};
	}



	componentDidMount() {
		this.setState({
			isAPILoaded: true,
			images: JSON.parse(this.props.images),
			old_images: JSON.parse(this.props.images)
		});
	}

	


	setText(index,value){
		this.setState(prevState => {
			const imagesCopy = [...prevState.images.images];
			imagesCopy[index] = { ...imagesCopy[index], alt_text: value };
			return { images: { ...prevState.images, images: imagesCopy } };
		});
	}

	saveAlt(index){
		let alt_text = this.state.images.images[index].alt_text;
		if(this.state.old_images.images[index].alt_text != alt_text){
			
			// ajax here
			this.setState({ isAPISaving: true });

			wp.apiRequest( {
				path: 'every-alt-api/v1/save_alt',
				method: 'POST',
				
				data: {
					media_id: this.state.images.images[index].media_id,
					log_id: this.state.images.images[index].id,
					alt_text: alt_text,

				}

				


			  } ).then( response => {
				console.log(response)
				this.setState({ isAPISaving: false });
				dispatch('core/notices')
				.createNotice(
					'success',
					__('Alt Text Saved', 'every-alt'),
					{
					type: 'snackbar',
					isDismissible: true,
					spokenMessage: __('Every Alt', 'every-alt'),
					}
				);
			});



			

			this.setState(prevState => {
				const imagesCopy = [...prevState.old_images.images];
				imagesCopy[index] = { ...imagesCopy[index], alt_text: alt_text };
				return { old_images: { ...prevState.old_images, images: imagesCopy } };
			});
			
			
		}
		
		
	}

	

	render() {
		if ( ! this.state.isAPILoaded ) {
			return (
				<Placeholder>
					<Spinner/>
				</Placeholder>
			);
		}
		
		return (
			<Fragment>
				<AppNotices/>	
				{this.state.images.images && this.state.images.images.length ? 
					<div id="every-alt-history-images">
						{this.state.images.images.map((item, index) => (
							<Card key={index}>
								<CardBody>
									<a href={this.props.admin + 'post.php?post=' + item.media_id + '&action=edit' }>
										<img src={item.image_url}  alt={item.alt_text}/>
									</a>
									<TextareaControl
										label={__( 'Alt Text','every-alt' )}
										value={ item.alt_text }
										onChange={ ( value ) => this.setText( index,value ) }
										onBlur={ () => this.saveAlt( index ) }
									/>
								</CardBody>
							</Card>
						))}
					</div>
				: 
				<div id="every-alt-history-images-empty">
					<Card>
						<CardBody>
							<h3>{ __( 'No alt text has been generated at this time.','every-alt' ) }</h3>
						</CardBody>
					</Card>
				</div>
				}
			</Fragment>
		);
	}
}


const app = document.getElementById('every-alt-history');
ReactDOM.render(<App {...app.dataset} />, app);