/* eslint-disable camelcase */
/**
 * WordPress dependencies
 */

const { __ } = wp.i18n;
const {
	BaseControl,
	Button,
	ExternalLink,
	PanelBody,
	PanelRow,
	Placeholder,
	Spinner,
	ToggleControl,
	Notice,
	Snackbar,
	SnackbarList,
	Card,
  	CardHeader,
	CardBody,
	CardFooter,
	TextareaControl
	
} = wp.components;

const {
	render,
	Component,
	Fragment,
} = wp.element;

const {
	useDispatch,
	dispatch, 
	withSelect, 
	withDispatch
} = wp.data;

const {
	compose,
} = wp.compose;



const {store: noticesStore} = wp.notices;

const Notices = ({ notices, removeNotice }) => {
    const snackbarNotices = notices ? notices.filter((notice) => notice.type === 'snackbar') : [];
    return (
        <>
            <SnackbarList
                className="every-alt-notices"
                notices={snackbarNotices}
                onRemove={removeNotice}
            />
        </>
    );
}

const AppNotices = compose(
    withSelect((select) => ({
        notices: select('core/notices').getNotices(),
    })),
    withDispatch((dispatch) => ({
        removeNotice: dispatch('core/notices').removeNotice,
    })),
)(Notices);


class App extends Component {
	constructor(props) {
		super( ...arguments );
		this.state = {
			isAPILoaded: false,
		};
	}



	componentDidMount() {
		this.setState({
			isAPILoaded: true,
		});
	}

	generateAltText(){
		this.setState({
			isAPILoaded: false,
		});
		wp.apiRequest({
			path: 'every-alt-api/v1/bulk_generate_alt',
			method: 'POST',
			data: {
			media_id: this.props.media,
			},
		}).then( response => {
			this.setState({
				isAPILoaded: true,
			});
			
			if(response.alt_text){

			
			//update the value of textarea
			var textarea = document.getElementById("attachment_alt");
			if(textarea){
				textarea.value = response.alt_text;
			}
			dispatch('core/notices')
				.createNotice(
					'success',
					__('Alt Text Saved', 'every-alt'),
					{
					type: 'snackbar',
					isDismissible: true,
					spokenMessage: __('Every Alt', 'every-alt'),
					}
				);
			}else{
				dispatch('core/notices')
				.createNotice(
					'success',
					__('Something went wrong please try later', 'every-alt'),
					{
					type: 'snackbar',
					isDismissible: true,
					spokenMessage: __('Every Alt', 'every-alt'),
					}
				);
			}
		});
	}

	render() {
		if ( ! this.state.isAPILoaded ) {
			return (
				<Spinner/>
			);
		}
		
		return (
			<Fragment>
				<AppNotices/>
				<Button
					isPrimary
					disabled={ this.state.isAPISaving }
					onClick={ () => this.generateAltText() }
					>
					{ __( 'Generate Alt Text for this Image','every-alt' ) }
				</Button>
				

              
			</Fragment>
		);
	}
}

document.addEventListener("DOMContentLoaded", function() {
	// Get the element by ID
	var customMediaButton = document.getElementById("every-alt-custom-media-button");
		if(customMediaButton){
		// Get the element after which the customMediaButton will be moved
		var altText = document.getElementById("attachment_alt");
		// Move the customMediaButton after the altText element
		altText.parentNode.insertBefore(customMediaButton, altText.nextSibling);
		setTimeout(() => {
			const app = document.getElementById('every-alt-custom-media-button');
    		ReactDOM.render(<App {...app.dataset} />, app);
		}, 100);
	}
});

