<?php

/**
 * Fired during plugin delete
 *
 * @link       https://hdc.dev
 * @since      0.0.1
 *
 * @package    Every_Alt
 * @subpackage Every_Alt/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      0.0.1
 * @package    Every_Alt
 * @subpackage Every_Alt/includes
 * @author     HDC <info@hdc.dev>
 */
class Every_Alt_Delete {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    0.0.1
	 */
	public static function delete() {
		// Get global $wpdb object
		global $wpdb;
		// Set the name of the table to delete
		$table_name = $wpdb->prefix . 'every_alt_logs';
		// Execute an SQL query to drop the table
		$wpdb->query( "DROP TABLE IF EXISTS {$table_name}" );

	}

}
