<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://hdc.dev
 * @since             0.0.1
 * @package           Every_Alt
 *
 * @wordpress-plugin
 * Plugin Name:       EveryAlt
 * Plugin URI:        https://everyalt.com
 * Description:       Instantly generate alternative text for all your images.
 * Version:           0.0.4
 * Author:            HDC
 * Author URI:        https://workwithhdc.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       every-alt
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EVERY_ALT_VERSION', '0.0.4' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-every-alt-activator.php
 */
function activate_every_alt() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-every-alt-activator.php';
	Every_Alt_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-every-alt-deactivator.php
 */
function deactivate_every_alt() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-every-alt-deactivator.php';
	Every_Alt_Deactivator::deactivate();
}

/**
 * The code that runs during plugin delete
 * This action is documented in includes/class-every-alt-delete.php
 */
// function delete_every_alt() {
// 	global $wpdb;
// 	$table_name = $wpdb->prefix . 'every_alt_logs';
// 	$wpdb->query( "DROP TABLE IF EXISTS {$table_name}" );
// }
// register_uninstall_hook( __FILE__, 'delete_every_alt' );

register_activation_hook( __FILE__, 'activate_every_alt' );
register_deactivation_hook( __FILE__, 'deactivate_every_alt' );


/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-every-alt.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_every_alt() {

	$plugin = new Every_Alt();
	$plugin->run();

}
run_every_alt();
